ADRSCORE	EQU	&A000
TILESFONTE	EQU	&7078
;adr = &67E0 + recompense (4*3*11 = 132) + chiffres (10*2*11 = 220) + vide/mur/virus (14*6*22 = 1848)


ORG &9000
; Kukulcan 2016
; ****************************
; *** RSX - INITIALISATION ***
; ****************************
.RSX_Init :
	LD	HL,RSX_Init
	LD	(HL),&C9            ; Ecrire un RET pour empecher une nouvelle initialisation
	LD	BC,RSX_Commandes    ; BC pointe sur la table des Commandes RSX
	LD	HL,RSX_Tampon       ; HL pointe sur 4 octets libres.
	JP	&BCD1

.RSX_Tampon :
	DEFS	4                   ; Tampon de quatre octets.

.RSX_Commandes :
	DEFW	RSX_Mots_Clefs      ; Adresse des mots clefs
	JP	CONV_LINEAIRE
	JP	AFF_CIBLE
	JP	AFF_SPRITE
	JP	OUT40
	JP	OUT32
	JP	MENU
	JP	ROUTINEHIST
	JP	ROUTINECONTROLS
	JP	ROUTINECREDIT
	JP	MSG
	JP	SCORECLEAN
	JP	STATS
	JP	FX
	JP	AFFRESULT
	JP	TILE8
	JP	CLS

.RSX_Mots_Clefs
	DEFB    "CON","V"+&80
	DEFB	"CIBL","E"+&80
	DEFB	"SP","R"+&80
	DEFB	"OUT4","0"+&80
	DEFB	"OUT3","2"+&80
	DEFB	"MEN","U"+&80
	DEFB	"AFFHIS","T"+&80
	DEFB	"AFFCTR","L"+&80
	DEFB	"AFFCREDIT","S"+&80
	DEFB	"MS","G"+&80
	DEFB	"SCORECLEA","N"+&80
	DEFB	"STAT","S"+&80
	DEFB	"F","X"+&80
	DEFB	"AFFRESUL","T"+&80
	DEFB	"TILE","8"+&80
	DEFB	"CL","S"+&80
	DEFB    0                ; Fin de la table.

;syntax |CONV,adresse_ecran,adresse_destination,largeur,hauteur
CONV_LINEAIRE
		;lecture valeur hauteur
		LD A,(IX+0)
		LD (conv_hauteur+1),A

		;lecture valeur largeur
		LD A,(IX+2)
		LD (conv_largeur+1),A

		;lecture valeur adresse_destination
		LD D,(IX+5)
		LD E,(IX+4)

		;lecture valeur adresse_ecran
		LD H,(IX+7)
		LD L,(IX+6)

conv_hauteur:
		LD B,0		 	;//nb de ligne (Hauteur)
conv_infos:
		PUSH BC 		;//ecrire BC dans la pile
		PUSH HL 		;//ecrire HL dans la pile
conv_largeur
		LD B,0			;//largeur du sprite (en octet)
conv_ligne:
		LD A,(HL) 		;//a = valeur de l'octet a l'ecran
		LD (DE),A 		;//ecrire dans destination la valeur de a
		INC DE			;//adresse de destination suivante
		INC HL			;//adresse ecran suivante
		DJNZ conv_ligne		;//B=B-1 si B est <> 0 alors on boucle sur ligne
					;B=0, calculer l'adresse de la prochaine ligne a l'ecran
		POP HL			;//recuperer HL de la pile
		;CALL &BC26		;//Calcul ligne ecran suivante (vers le BAS)
		CALL conv_ligne_suivante
		POP BC			;//recuperer BC de la pile (C'est surtout pour le registre B
					;//contenant le nombre de ligne que c'est interessant, vu qu'on
					;//l'utilise 2 fois ce registre dans la routine)
		DJNZ conv_infos		;//B=B-1 si B <>0 on boucle dans infos
		RET			;//retour au basic, toutes les lignes ont ete traitees

conv_ligne_suivante:
		LD A,H
		ADD A,#08
		LD H,A
		RET NC
		LD BC,#C050
		ADD HL,BC
		RET


;syntax |CIBLE,adresse_ecran,adresse_sprite,largeur,hauteur
;Routine de Christphe PETIT - Affichage d'un sprite entier avec transparence sur l'encre 0 en mode 1
.AFF_CIBLE
		;lecture valeur hauteur
		LD A,(IX+0)
		LD (cible_hauteur+1),A

		;lecture valeur largeur
		LD A,(IX+2)
		LD (cible_largeur+1),A

		;lecture valeur adresse_sprite
		LD H,(IX+5)
		LD L,(IX+4)

		;lecture valeur adresse_ecran
		LD D,(IX+7)
		LD E,(IX+6)

cible_hauteur	LD C,0
AFF_CIBLE1	PUSH DE
cible_largeur	LD B,0			; B = nombre d'octets a copier par ligne
AFF_CIBLE2	PUSH BC
		LD A,(HL)               ; A = octet courant du sprite
         	LD C,A                  ; puis C
	        RLCA
		RLCA
		RLCA
		RLCA                    ; Inversion poids faible <-> poids fort
         	OR C                    ; A = masque des couleurs de sprite a conserver
         	CPL                     ; inversion pour masque des couleurs de fond a supprimer
         	LD B,A                  ; B = masque des couleurs a supprimer
         	LD A,(DE)               ; A = octet de fond d'ecran courant
         	AND B                   ; suppression des couleurs genantes
         	OR C                    ; ajout des couleurs du sprite
         	LD (DE),A               ; affichage du resultat
		INC HL
		INC DE
		POP BC
		DJNZ AFF_CIBLE2	; Rebouclage jusqu'a traitement complet de la ligne

		POP DE
		PUSH BC
		CALL ligne_suivante_suivant_R1
		POP BC
		DEC C
		JR NZ,AFF_CIBLE1
		RET


;syntax |FX,valeur (0 ou 1)
.FX
		LD A,(IX+0)

		LD C,8	;la parenthese ouverte commence a la position 8
		ADD C

		LD L,A		;L = A
		LD H,0		;H = 0
		;HL contient A (A * 2*8=16)
		ADD HL,HL 	;*2
		ADD HL,HL 	;*4
		ADD HL,HL 	;*8
		ADD HL,HL 	;*16
		LD DE,TILESFONTE
		ADD HL,DE	;HL contient l'adresse du tiles	

		LD A,8
		LD (spr_hauteur+1),A
		LD A,2
		LD (spr_largeur+1),A

		LD DE,&DF95
		CALL spr_hauteur
		RET

;syntax |SPR,adresse_ecran,adresse_sprite,largeur,hauteur
.AFF_SPRITE
		;lecture valeur hauteur
		LD A,(IX+0)
		LD (spr_hauteur+1),A

		;lecture valeur largeur
		LD A,(IX+2)
		LD (spr_largeur+1),A

		;lecture valeur adresse_sprite
		LD H,(IX+5)
		LD L,(IX+4)

		;lecture valeur adresse_ecran
		LD D,(IX+7)
		LD E,(IX+6)
spr_hauteur
		LD A,&20	;hauteur
spr_loop
		PUSH AF
		PUSH DE
spr_largeur
		LD BC,&0000	;largeur
		LDIR
		POP DE
		CALL ligne_suivante_suivant_R1
		POP AF
		DEC A
		JR NZ,spr_loop 

.ligne_suivante_suivant_R1
		LD A,D
		ADD A,8
		LD D,A
		AND &38
		RET NZ
		LD A,D
		SUB &40
		LD D,A
		LD A,E
		ADD A,&40	;si R1=40 alors &50 si R1=41 alors &52 si R1=32 alors &40
		LD E,A
		RET NC
		INC D
		LD A,D
		AND 7
		RET NZ
		LD A,D
		SUB 8
		LD D,A
		RET

.OUT40
	LD BC,&BC01
	OUT(C),C
	LD BC,&BD00+40
	OUT(C),C

	LD BC,&BC02
	OUT(C),C
	LD BC,&BD00+46
	OUT(C),C

	LD BC,&BC06
	OUT(C),C
	LD BC,&BD00+25
	OUT(C),C

	LD BC,&BC07
	OUT(C),C
	LD BC,&BD00+30
	OUT(C),C
	RET
.OUT32
	;largeur
	LD BC,&BC01
	OUT (C),C
	LD BC,&BD20
	OUT (C),C

	;hauteur
	LD BC,&BC06
	OUT (C),C
	LD BC,&BD20
	OUT (C),C

	;decalage horizontal
	LD BC,&BC02
	OUT (C),C
	LD BC,&BD2A
	OUT (C),C

	;decalage vertical
	LD BC,&BC07
	OUT (C),C
	LD BC,&BD22
	OUT (C),C
	RET

.MENU
AFFICHAGE_MENU_PRINCIPAL
	LD HL,MENU0
	LD DE,&D957
	CALL directmini
	LD HL,MENU1
	LD DE,&FA94
	CALL directmini
	LD HL,MENU2
	LD DE,&EB54
	CALL directmini
	LD HL,MENU3
	LD DE,&DC14
	CALL directmini
	LD HL,MENU4
	LD DE,&CCD4
	CALL directmini
	LD HL,MENU5
	LD DE,&FD54
	CALL directmini
	LD HL,MENU6
	LD DE,&EE08
	CALL directmini
	RET
MENU0	DEFB "*M*E*N*U*"
	DB 0 ;fin d'affichage
MENU1	DEFB "1 - PLAY"
	DB 0 ;fin d'affichage
MENU2	DEFB "2 - THE STORY"
	DB 0 ;fin d'affichage
MENU3	DEFB "3 - CONTROLS"
	DB 0 ;fin d'affichage
MENU4	DEFB "4 - CREDITS"
	DB 0 ;fin d'affichage
MENU5	DEFB "5 - RESULTS"
	DB 0 ;fin d'affichage
MENU6	DEFB "2016 @ WWW.CPC-POWER.COM"
	DB 0 ;fin d'affichage

ROUTINEHIST
	LD HL,HIST0
	LD DE,&D951
	CALL directmini
	LD HL,HIST1
	LD DE,&FA85+1
	CALL directmini
	LD HL,HIST2
	LD DE,&EB45+1
	CALL directmini
	LD HL,HIST3
	LD DE,&DC05+1
	CALL directmini
	LD HL,HIST4
	LD DE,&CCC5+1
	CALL directmini
	LD HL,HIST5
	LD DE,&FD45+1
	CALL directmini
	LD HL,HIST6
	LD DE,&EE05+1
	CALL directmini
	RET
	     ;012345678901234567890123456
HIST0	DEFB "**THE***STORY**"
	DB 0 ;fin d'affichage
HIST1	DEFB "YOUR DOG W.CAMELOT IS ILL."
	DB 0 ;fin d'affichage
HIST2	DEFB "VIRUSES ARE ATTACKING HIM."
	DB 0 ;fin d'affichage
HIST3	DEFB "YOUR MISSION IS TO GET RID"
	DB 0 ;fin d'affichage
HIST4	DEFB "OF  THEM  THROUGHOUT  THE "
	DB 0 ;fin d'affichage
HIST5	DEFB "50 LEVELS.       BEWARE!!!"
	DB 0 ;fin d'affichage
HIST6	DEFB " VIRUSES   ARE   CLEVER!!!"
	DB 0 ;fin d'affichage

ROUTINECONTROLS
	LD HL,CTRL0
	LD DE,&D94F
	CALL directmini
	LD HL,CTRL1
	LD DE,&FA85+1
	CALL directmini
	LD HL,CTRL2
	LD DE,&EB45+1
	CALL directmini
	LD HL,CTRL3
	LD DE,&DC05+1
	CALL directmini
	LD HL,CTRL4
	LD DE,&CCC5+1
	CALL directmini
	LD HL,CTRL5
	LD DE,&FD45+1
	CALL directmini
	LD HL,CTRL6
	LD DE,&EE05+1
	CALL directmini
	RET
	     ;012345678901234567890123456
CTRL0	DEFB "*C*O*N*T*R*O*L*S*"
	DB 0 ;fin d'affichage
CTRL1	DEFB "MOVE CURSOR AND VIRUS WITH"
	DB 0 ;fin d'affichage
CTRL2	DEFB "JOYSTICK  OR  ARROW  KEYS."
	DB 0 ;fin d'affichage
CTRL3	DEFB "     R=RESTART LEVEL      "
	DB 0 ;fin d'affichage
CTRL4	DEFB "A=ABORT GAME      M=( OR )"
	DB 0 ;fin d'affichage
CTRL5	DEFB "KILL EVERY VIRUS TO ACCESS"
	DB 0 ;fin d'affichage
CTRL6	DEFB "   TO  THE  NEXT  LEVEL.  "
	DB 0 ;fin d'affichage

ROUTINECREDIT
	LD HL,CREDIT0
	LD DE,&D951
	CALL directmini
	LD HL,CREDIT1
	LD DE,&FA85
	CALL directmini
	LD HL,CREDIT2
	LD DE,&EB45
	CALL directmini
	LD HL,CREDIT3
	LD DE,&DC05
	CALL directmini
	LD HL,CREDIT4
	LD DE,&CCC5
	CALL directmini
	LD HL,CREDIT5
	LD DE,&FD45
	CALL directmini
	LD HL,CREDIT6
	LD DE,&EE05
	CALL directmini
	RET

             ;012345678901234567890123456
CREDIT0	DEFB "*C*R*E*D*I*T*S*"
	DB 0 ;fin d'affichage
CREDIT1	DEFB "   IDEA & CODE: KUKULCAN   "
	DB 0 ;fin d'affichage
CREDIT2	DEFB "    GFX: KUKULCAN & CED    "
	DB 0 ;fin d'affichage
CREDIT3	DEFB "      MUSIC: T&J/GPA       "
	DB 0 ;fin d'affichage
CREDIT4	DEFB "   COVER & MANUAL: IXIEN   "
	DB 0 ;fin d'affichage
CREDIT5	DEFB "TESTERS: AST*GALAMOTH*LONE*"
	DB 0 ;fin d'affichage
CREDIT6 DEFB " *MAXIT*C.PETIT*FREDOUILLE*"
	DB 0 ;fin d'affichage

;
.AFFRESULT
	LD HL,AFFRES0
	LD DE,&D951
	CALL directmini

	;cadre
	LD HL,resultligne
	LD DE,&D4D3
	CALL directmini

	LD HL,&70C8
	LD DE,&D513
	CALL stats_aff_TILES_1
	LD HL,&70C8
	LD DE,&D513+22
	CALL stats_aff_TILES_1

	LD HL,&70C8
	LD DE,&D553
	CALL stats_aff_TILES_1
	LD HL,&70C8
	LD DE,&D553+22
	CALL stats_aff_TILES_1

	LD HL,&70C8
	LD DE,&D593
	CALL stats_aff_TILES_1
	LD HL,&70C8
	LD DE,&D593+22
	CALL stats_aff_TILES_1

	LD HL,&70C8
	LD DE,&D5D3
	CALL stats_aff_TILES_1
	LD HL,&70C8
	LD DE,&D5D3+22
	CALL stats_aff_TILES_1

	LD HL,&70C8
	LD DE,&D613
	CALL stats_aff_TILES_1
	LD HL,&70C8
	LD DE,&D613+22
	CALL stats_aff_TILES_1

	LD HL,resultligne
	LD DE,&D653
	CALL directmini

	;sprite
	LD A,40
	LD (spr_hauteur+1),A
	LD A,20
	LD (spr_largeur+1),A
	LD HL,&A1D0
	LD DE,&D515
	CALL spr_hauteur

	RET
resultligne 	DEFB "%%%%%%%%%%%%"
		DB 0;fin d'affichage

AFFRES0	DEFB "*R*E*S*U*L*T*S*"
	DB 0 ;fin d'affichage


AFFICHAGE_MINI_TEXTE
;	LD HL,TEXTE1
;	LD DE,&C000 ;adresse affichage a l'ecran

;le texte devra obligatoirement avoir un zero a la fin
	;lecture valeur adresse_texte
	LD H,(IX+3)
	LD L,(IX+2)

	;lecture valeur adresse_ecran
	LD D,(IX+1)
	LD E,(IX+0)
directmini
	;lecture valeur hauteur
	LD A,8
	LD (spr_hauteur+1),A

	;lecture valeur largeur
	LD A,2
	LD (spr_largeur+1),A	
loop_affichage_mini_texte
	LD A,(HL)
	CP 0
	RET Z
	
	LD C,32
	SUB C	;A = A-32
	
	PUSH HL	;sauver HL
	PUSH DE ;sauver DE
	;CALL &BB5A
	LD L,A		;L = A
	LD H,0		;H = 0
	;HL contient A (A * 2*8=16)
	ADD HL,HL 	;*2
	ADD HL,HL 	;*4
	ADD HL,HL 	;*8
	ADD HL,HL 	;*16
	LD DE,TILESFONTE
	ADD HL,DE	;HL contient l'adresse du tiles	

	POP DE		;recuperer l'adresse d'affichage a l'ecran
	PUSH DE		;on resauve DE
	CALL spr_hauteur	;affichage du sprite
	POP DE		;on recupere
	INC DE
	INC DE		;position suivante a l'ecran +2

	POP HL 	;recuperer HL
	INC HL	;position caractere suivant
	
	JR loop_affichage_mini_texte

;syntax |MSG,numero_texte
.MSG
	LD A,(IX+0)

	LD HL,adresse_messages-26

.msgloop
	LD DE,26
	ADD HL,DE

	DEC A
	CP -1
	JP NZ,msgloop

	LD DE,&D6C7
	CALL directmini

	RET

.adresse_messages
	    ;"0123456789012345678901234" 25 caracteres + 1 a zero
	DEFB "         EMPTY           ":DB 0 ;0
	DEFB "        OBSTACLE         ":DB 0 ;1
	DEFB " VIRUS *BDCIRON*  TYPE # ":DB 0 ;2
	DEFB " VIRUS *PLISSKEN* TYPE # ":DB 0 ;3
	DEFB " VIRUS *DECKARD*  TYPE # ":DB 0 ;4
	DEFB " VIRUS *XTRABET*  TYPE # ":DB 0 ;5 
	DEFB " VIRUS *KALIDOR*  TYPE # ":DB 0 ;6
	DEFB " VIRUS *ZISQUIER* TYPE # ":DB 0 ;7
	DEFB " VIRUS *BDCIRON*  TYPE $ ":DB 0 ;8
	DEFB " VIRUS *PLISSKEN* TYPE $ ":DB 0 ;9
	DEFB " VIRUS *DECKARD*  TYPE $ ":DB 0 ;10
	DEFB " VIRUS *XTRABET*  TYPE $ ":DB 0 ;11
	DEFB " VIRUS *KALIDOR*  TYPE $ ":DB 0 ;12
	DEFB " VIRUS *ZISQUIER* TYPE $ ":DB 0 ;13
	DEFB "WARNING, IT'S NOT A VIRUS":DB 0 ;14
	DEFB "VIRUS SELECTED, MOVE NOW?":DB 0 ;15
	DEFB "      ILLEGAL MOVE       ":DB 0 ;16
	DEFB "WELL DONE VIRUS DESTROYED":DB 0 ;17
	DEFB "    VIRUS UNSELECTED     ":DB 0 ;18
	DEFB "                         ":DB 0 ;19
	DEFB "  WAIT FOR LEVEL RELOAD  ":DB 0 ;20
	DEFB "       GAME ABORDED      ":DB 0 ;21
	DEFB "   WELCOME TO VIRUSDOG   ":DB 0 ;22
	DEFB "***** LEVEL FINISHED ****":DB 0 ;23
	DEFB "      SCORES LOADED      ":DB 0 ;24
	DEFB "      SCORES SAVED       ":DB 0 ;25
	DEFB "      SCORES RESET       ":DB 0 ;26

;syntax |
.SCORECLEAN
	LD HL,ADRSCORE
	LD DE,ADRSCORE+1
	LD BC,150 ;(2 scores + 1 rank)*50 niveaux
	LD (HL),0
	LDIR
	;lvlunlock
	LD A,4
	LD (ADRSCORE+151),A
	RET


;|STATS
.STATS
	LD IX,stats_texte
	LD DE,&C20F 	;affichage ecran
	LD A,11 	;nombre de ligne a afficher

.stats_aff_3
	PUSH AF
	PUSH DE 	; on sauvegarde l'adresse video de la premiere ligne de sprites a afficher
	LD A,17		;nombre de colonne a afficher

.stats_aff_2
	PUSH AF

	LD A,(IX+&00)
	INC IX

	LD L,A
	LD H,0
	ADD HL,HL ; x2
	ADD HL,HL ; x4
	ADD HL,HL ; x8
	ADD HL,HL ; x16 (largeur 2 octets x 8 lignes pour un tile en 8x8)

	LD BC,TILESFONTE-&200	;(evite une soustraction sur A avec 32caracteres*2octets*8lignes)
	ADD HL,BC

	PUSH DE
	CALL stats_aff_TILES_1
	POP DE

.stats_aff_1
	INC DE      ;Case suivante (decalage de 2 octets sur la droite)
	INC DE

	POP AF
	DEC A
	JR NZ,stats_aff_2

	POP HL
	LD BC,&0040	;&50 = normal - R1=32 alors &40
	ADD HL,BC
	EX DE,HL   	;Ligne suivante
	POP AF
	DEC A
	JR NZ,stats_aff_3

	RET

;syntax |tile8,adresse_memoire,adresse_ecran
.TILE8
	;lecture valeur adresse_memoire
	LD H,(IX+3)
	LD L,(IX+2)

	;lecture valeur adresse_ecran
	LD D,(IX+1)
	LD E,(IX+0)

.stats_aff_TILES_1
        LD A,8 		;Hauteur_du_tile
.stats_aff_TILES_2
        LDI
        LDI		;8 pixels = 2 octets en MODE 1
        EX DE,HL
        LD BC,&07FE 	;&800 - 2 octets (largeur ecran - largeur tiles)
        ADD HL,BC
        JR NC,stats_aff_TILES_3
        LD BC,&C040	;R1=40 alors &C050 (normal) - R1=32 alors &C040 (reduit)
        ADD HL,BC
.stats_aff_TILES_3
        EX DE,HL
        DEC A
        JR NZ,stats_aff_TILES_2
        RET

;syntax |CLS,adresse_ecran,numero
.CLS
;&5D10 effacement,1
;&5D94 effacement,2
;&5E18 effacement,3
;&5E9C effacement,4
;&5F20 effacement,5
;&5FA4 effacement,6
	LD A,(IX+0)
	LD HL,&5D10-132
.clsloop
	LD DE,132
	ADD HL,DE

	DEC A
	CP -1
	JP NZ,clsloop

	;lecture valeur adresse_ecran
	LD D,(IX+3)
	LD E,(IX+2)

	;ecriture valeur hauteur
	LD A,22
	LD (cible_hauteur+1),A
	;ecriture valeur largeur
	LD A,6
	LD (cible_largeur+1),A

	;lecture valeur adresse_sprite
	CALL cible_hauteur
	RET

org #9F00
.stats_texte
DEFB	"%%%%%%%%%%%%%%%%%"
DEFB	"% *L*E*V*E*L*S* %"
DEFB	"%+++++++++++++++%"
DEFB	"%1-PERFECT % 00 %"
DEFB	"%++++++++++%++++%"
DEFB	"%2-GOOD    % 00 %"
DEFB	"%++++++++++%++++%"
DEFB	"%3-BAD     % 00 %"
DEFB	"%++++++++++%++++%"
DEFB	"%X-NOTHING % 00 %"
DEFB	"%++++++++++%++++%"
DEFB    0
